<?php
include("connexion.php");

$billet_id = intval($_GET['id_billet']);
$message = '';

// Récupération des informations du billet
$stmt = $db->prepare("SELECT * FROM billets WHERE id = :id");
$stmt->bindValue(':id', $billet_id, PDO::PARAM_INT);
$stmt->execute();
$billet = $stmt->fetch(PDO::FETCH_ASSOC);

// Récupération des commentaires associés au billet
$stmt_comments = $db->prepare("SELECT * FROM commentaires WHERE id_billet = :id_billet");
$stmt_comments->bindValue(':id_billet', $billet_id, PDO::PARAM_INT);
$stmt_comments->execute();
$commentaires = $stmt_comments->fetchAll(PDO::FETCH_ASSOC);

// Supprimer un commentaire
if (isset($_POST['supprimer_commentaire'])) {
    $commentaire_id = intval($_POST['commentaire_id']);
    $stmt = $db->prepare("DELETE FROM commentaires WHERE id = :id");
    $stmt->bindValue(':id', $commentaire_id, PDO::PARAM_INT);
    $stmt->execute();

    $message = "Commentaire supprimé avec succès.";
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Commentaires de <?= htmlspecialchars($billet['titre']) ?></title>
    <link href="CSS/mcomm.css" rel="stylesheet">
</head>
<body>
<header>
    <div class="logo"><a href="admin.php">ADMIN</a></div>
    <div class="nav-buttons">
        <a href="deco.php">Déconnexion</a>
    </div>
</header>

<h2>Commentaires pour : <?= htmlspecialchars($billet['titre']) ?></h2>

<?php if ($message): ?>
    <div class="message"><?= $message ?></div>
<?php endif; ?>

<?php if ($commentaires): ?>
    <?php foreach ($commentaires as $commentaire): ?>
        <div class="commentaire">
                <strong>Auteur :</strong> <?= htmlspecialchars($commentaire['auteur']) ?><br>
                <strong>Date :</strong> <?= htmlspecialchars($commentaire['date_post']) ?><br>
                <strong>Contenu :</strong> <?= htmlspecialchars($commentaire['contenu']) ?><br>
            <a class="btn" href="editcomm.php?id=<?= $commentaire['id'] ?>">Modifier</a>
            <form action="" method="post" style="display:inline;">
                <input type="hidden" name="commentaire_id" value="<?= $commentaire['id'] ?>">
                <input type="submit" name="supprimer_commentaire" value="Supprimer">
            </form>
        </div>
    <?php endforeach; ?>
<?php else: ?>
    <div class="message">Aucun commentaire trouvé pour ce billet.</div>
<?php endif;?>

<div class='back-button'>
    <button type='button' onclick='window.history.back();'>Retour</button>
</div>


</body>
</html>